package com.agilex.healthcare.veteranappointment.datalayer.appointment;

import com.agilex.healthcare.veteranappointment.datalayer.AbstractDao;
import com.agilex.healthcare.veteranappointment.datalayer.userhistory.UserHistoryEntityManager;
import com.agilex.healthcare.veteranappointment.domain.CCAppointmentRequest;
import com.agilex.healthcare.veteranappointment.domain.VARAppointmentRequest;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;

@Repository
public class CCAppointmentRequestDao extends AbstractDao {

    @Resource
    private AppointmentRequestDao appointmentRequestDao;

    @Transactional(propagation = Propagation.REQUIRED)
    public CCAppointmentRequest saveCCAppointmentRequest(CCAppointmentRequest ccAppointmentRequest) {

        VARAppointmentRequest existingAppointmentRequest = appointmentRequestDao.getAppointmentRequestIfItExists(
                ccAppointmentRequest.getAppointmentRequestId());

        if (existingAppointmentRequest != null) {
            ccAppointmentRequest.setHasProviderNewMessage(existingAppointmentRequest.isHasProviderNewMessage());
            ccAppointmentRequest.setHasVeteranNewMessage(existingAppointmentRequest.isHasVeteranNewMessage());
        }

        UserHistoryEntityManager<CCAppointmentRequestPo> simpleEntityManager = new
                UserHistoryEntityManager<>(entityManager, CCAppointmentRequestPo.TABLE_NAME, ccAppointmentRequest);
        CCAppointmentRequestPo savedAppointmentRequest = simpleEntityManager.save(new CCAppointmentRequestPo(ccAppointmentRequest));

        if (savedAppointmentRequest != null) {
            return savedAppointmentRequest.create();
        }

        return null;
    }
}
